/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.content.logistics.item.LinkedControllerModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class LinkedControllerItemRenderer
extends CustomRenderedItemModelRenderer<LinkedControllerModel> {
    static LerpedFloat equipProgress = LerpedFloat.linear().startWithValue(0.0);
    static Vector<LerpedFloat> buttons = new Vector(6);

    static void tick() {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        boolean active = LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
        equipProgress.chase(active ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        equipProgress.tickChaser();
        if (!active) {
            return;
        }
        for (int i = 0; i < buttons.size(); ++i) {
            LerpedFloat lerpedFloat = buttons.get(i);
            lerpedFloat.chase(LinkedControllerClientHandler.currentlyPressed.contains(i) ? 1.0 : 0.0, 0.4f, LerpedFloat.Chaser.EXP);
            lerpedFloat.tickChaser();
        }
    }

    static void resetButtons() {
        for (int i = 0; i < buttons.size(); ++i) {
            buttons.get(i).startWithValue(0.0);
        }
    }

    @Override
    protected void render(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemTransforms.TransformType transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        LinkedControllerItemRenderer.renderNormal(stack, model, renderer, transformType, ms, light);
    }

    protected static void renderNormal(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemTransforms.TransformType transformType, PoseStack ms, int light) {
        LinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.NORMAL, false, false);
    }

    public static void renderInLectern(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemTransforms.TransformType transformType, PoseStack ms, int light, boolean active, boolean renderDepression) {
        LinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.LECTERN, active, renderDepression);
    }

    protected static void render(ItemStack stack, LinkedControllerModel model, PartialItemModelRenderer renderer, ItemTransforms.TransformType transformType, PoseStack ms, int light, RenderType renderType, boolean active, boolean renderDepression) {
        float pt = AnimationTickHolder.getPartialTicks();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ms.m_85836_();
        if (renderType == RenderType.NORMAL) {
            boolean noControllerInMain;
            Minecraft mc = Minecraft.m_91087_();
            boolean rightHanded = mc.f_91066_.f_92127_ == HumanoidArm.RIGHT;
            ItemTransforms.TransformType mainHand = rightHanded ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            ItemTransforms.TransformType offHand = rightHanded ? ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND : ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            active = false;
            boolean bl = noControllerInMain = !AllItems.LINKED_CONTROLLER.isIn(mc.f_91074_.m_21205_());
            if (transformType == mainHand || transformType == offHand && noControllerInMain) {
                float equip = equipProgress.getValue(pt);
                int handModifier = transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND ? -1 : 1;
                msr.translate(0.0, (double)(equip / 4.0f), (double)(equip / 4.0f * (float)handModifier));
                msr.rotateY((double)(equip * -30.0f * (float)handModifier));
                msr.rotateZ((double)(equip * -30.0f));
                active = true;
            }
            if (transformType == ItemTransforms.TransformType.GUI) {
                if (stack == mc.f_91074_.m_21205_()) {
                    active = true;
                }
                if (stack == mc.f_91074_.m_21206_() && noControllerInMain) {
                    active = true;
                }
            }
            active &= LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
            renderDepression = true;
        }
        renderer.render(active ? model.getPartial("powered") : model.getOriginalModel(), light);
        if (!active) {
            ms.m_85849_();
            return;
        }
        BakedModel button = model.getPartial("button");
        float s = 0.0625f;
        float b = s * -0.75f;
        int index = 0;
        if (renderType == RenderType.NORMAL && LinkedControllerClientHandler.MODE == LinkedControllerClientHandler.Mode.BIND) {
            int i = (int)Mth.m_14179_((float)((Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 2.0f), (float)5.0f, (float)15.0f);
            light = i << 20;
        }
        ms.m_85836_();
        msr.translate((double)(2.0f * s), 0.0, (double)(8.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(4.0f * s), 0.0, 0.0);
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(-2.0f * s), 0.0, (double)(2.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate(0.0, 0.0, (double)(-4.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        ms.m_85849_();
        msr.translate((double)(3.0f * s), 0.0, (double)(3.0f * s));
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        msr.translate((double)(2.0f * s), 0.0, 0.0);
        LinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression);
        ms.m_85849_();
    }

    protected static void renderButton(PartialItemModelRenderer renderer, PoseStack ms, int light, float pt, BakedModel button, float b, int index, boolean renderDepression) {
        ms.m_85836_();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            ms.m_85837_(0.0, (double)depression, 0.0);
        }
        renderer.renderSolid(button, light);
        ms.m_85849_();
    }

    @Override
    public LinkedControllerModel createModel(BakedModel originalModel) {
        return new LinkedControllerModel(originalModel);
    }

    static {
        for (int i = 0; i < 6; ++i) {
            buttons.add(LerpedFloat.linear().startWithValue(0.0));
        }
    }

    protected static enum RenderType {
        NORMAL,
        LECTERN;

    }
}

